package gov.cms.grouper.snf.model.table;

import gov.cms.grouper.snf.lego.CsvBuilder;
import gov.cms.grouper.snf.lego.SnfUtils;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public class SnfVersionRow {

  private Integer internalVersion;
  private LocalDate from;
  private LocalDate to;
  private String version;

  private SnfVersionRow() {
    this(null, null, null, null);
  }

  public SnfVersionRow(Integer internalVersion, LocalDate from, LocalDate to, String version) {
    super();
    this.internalVersion = internalVersion;
    this.from = from;
    this.to = to;
    this.version = version;
  }

  public Integer getInternalVersion() {
    return this.internalVersion;
  }

  public LocalDate getFrom() {
    return this.from;
  }

  public LocalDate getTo() {
    return this.to;
  }

  public String getVersion() {
    return this.version;
  }

  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((this.from == null) ? 0 : this.from.hashCode());
    result = prime * result + ((this.to == null) ? 0 : this.to.hashCode());
    result = prime * result + ((this.internalVersion == null) ? 0 : this.internalVersion.hashCode());
    result = prime * result + ((this.version == null) ? 0 : this.version.hashCode());
    return result;
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj) {
      return true;
    }
    if (obj == null) {
      return false;
    }
    if (this.getClass() != obj.getClass()) {
      return false;
    }
    SnfVersionRow other = (SnfVersionRow) obj;
    if (this.from == null) {
      if (other.from != null) {
        return false;
      }
    } else if (!this.from.equals(other.from)) {
      return false;
    }
    if (this.to == null) {
      if (other.to != null) {
        return false;
      }
    } else if (!this.to.equals(other.to)) {
      return false;
    }
    if (this.internalVersion == null) {
      if (other.internalVersion != null) {
        return false;
      }
    } else if (!this.internalVersion.equals(other.internalVersion)) {
      return false;
    }
    if (this.version == null) {
      if (other.version != null) {
        return false;
      }
    } else if (!this.version.equals(other.version)) {
      return false;
    }
    return true;
  }

  public static class Builder extends CsvBuilder<SnfVersionRow> {
    private static final DateTimeFormatter formatter = DateTimeFormatter.BASIC_ISO_DATE;

    private static final BiConsumer<SnfVersionRow, String> internalVersion =
        (row, str) -> row.internalVersion = SnfUtils.parse(str, null);

    private static final BiConsumer<SnfVersionRow, String> from =
        (row, str) -> row.from = SnfUtils.parseDate(formatter, str);

    private static final BiConsumer<SnfVersionRow, String> to =
        (row, str) -> row.to = SnfUtils.parseDate(formatter, str);

    private static final BiConsumer<SnfVersionRow, String> version =
        (row, str) -> row.version = str;

    private static final Builder singleton = new Builder();

    private Builder() {
      super(SnfVersionRow::new, Builder.initCsvMapping());
    }

    public static Map<Integer, BiConsumer<SnfVersionRow, String>> initCsvMapping() {
      Map<Integer, BiConsumer<SnfVersionRow, String>> result = new HashMap<>();
      result.put(0, Builder.internalVersion);
      result.put(1, Builder.from);
      result.put(2, Builder.to);
      result.put(3, Builder.version);

      return Collections.unmodifiableMap(result);
    }

    public static Builder of() {
      return Builder.singleton;
    }

  }

}
